﻿QIPortalAPI.Toast = function(toastText, toastCss) { 
    
    const toast = document.createElement('div');    
    toast.innerText = toastText;
    var textColorStr;  /*bg and text color rgba strings to change color during animation rewrite these*/
    var currentColorStr;
    
    var alphachannel = 0;
    var firstTop = 25;
    var step = 10;
    var derivation = 0.4;
    var top = 0;
    var interval2;
    var animationtTimer = 0;
    var visibility=true;
    toast.style.zIndex = 12;

    document.body.appendChild(toast);
    setToastDisplayColor();

    var cssClass = getComputedStyle(toast);
    if (cssClass.visibility == 'hidden') {
        visibility = false;
    }

    currentColorStr = stringAlphaChannelUpdate(cssClass.getPropertyValue('background-color'));
    textColorStr = stringAlphaChannelUpdate(cssClass.getPropertyValue('color')); 

    toast.style.left = 'calc(50% - ' + (toast.offsetWidth / 2)+'px)';

    var interval = setInterval(toastAppearAnimation, 20); //ticker for animation
    delay()

    function delay() {
        setTimeout(toastDisappearAnimationTicker, 3500);//delay between animations in ms
    }
    function toastDisappearAnimationTicker() {  //ticker for animation
        interval2 = setInterval(toastDisappearAnimation, 20);
    }

    function toastAppearAnimation() { /*toast appear animation*/
        
        animationtTimer = animationtTimer + step;
        step = step - derivation;
        alphachannel = animationtTimer / 100;
        setToastParameters();

        if (animationtTimer > 100) {
            clearInterval(interval);
            alphachannel = 1;
        } 
    }
    function toastDisappearAnimation() { /*disappear animation*/

        animationtTimer = animationtTimer - step;
        step = step + derivation;
        alphachannel = animationtTimer / 100;
        setToastParameters();
        

        if (animationtTimer < 0) {
            clearInterval(interval2);
            alphachannel = 0;
            toast.remove();
        }

    }

    function setToastDisplayColor() {/*set class from c# code*/
        if (toastCss=='success') {
            toast.className = 'MailToastSuccess';            
        }
        if (toastCss=='fail') {
            toast.className = 'MailToastError';
        }
    }

    function setToastParameters() { /*sets top and alphachannel*/
        top = firstTop + animationtTimer / 5;
        toast.style.top = top + "px";

        if (visibility) {
            toast.style.backgroundColor = currentColorStr + ',' + alphachannel + ')';
            toast.style.color = textColorStr + ',' + alphachannel + ')';
        }        
    }
    function stringAlphaChannelUpdate(str) { /*create string for alphachannel its fix for bug. if rgba alhpachannel is more then 1 then its rgb and it allows rewrite alphachannel in animation*/
        var words = str.split(',');
        words.pop();
        return words.join(',');
    }

}

